// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> The Cloud HSM Cluster's provisioningState. </summary>
    public readonly partial struct CloudHsmClusterProvisioningState : IEquatable<CloudHsmClusterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudHsmClusterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";
        private const string CanceledValue = "Canceled";

        /// <summary> Provisioning. </summary>
        public static CloudHsmClusterProvisioningState Provisioning { get; } = new CloudHsmClusterProvisioningState(ProvisioningValue);
        /// <summary> Succeeded. </summary>
        public static CloudHsmClusterProvisioningState Succeeded { get; } = new CloudHsmClusterProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static CloudHsmClusterProvisioningState Failed { get; } = new CloudHsmClusterProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static CloudHsmClusterProvisioningState Deleting { get; } = new CloudHsmClusterProvisioningState(DeletingValue);
        /// <summary> Canceled. </summary>
        public static CloudHsmClusterProvisioningState Canceled { get; } = new CloudHsmClusterProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="CloudHsmClusterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CloudHsmClusterProvisioningState left, CloudHsmClusterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudHsmClusterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CloudHsmClusterProvisioningState left, CloudHsmClusterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudHsmClusterProvisioningState"/>. </summary>
        public static implicit operator CloudHsmClusterProvisioningState(string value) => new CloudHsmClusterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudHsmClusterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudHsmClusterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
