// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> Properties of a Cloud HSM Cluster. </summary>
    public partial class CloudHsmClusterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterProperties"/>. </summary>
        public CloudHsmClusterProperties()
        {
            Hsms = new ChangeTrackingList<CloudHsmProperties>();
            PrivateEndpointConnections = new ChangeTrackingList<CloudHsmClusterPrivateEndpointConnectionData>();
        }

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterProperties"/>. </summary>
        /// <param name="activationState"> State of security domain activation. </param>
        /// <param name="autoGeneratedDomainNameLabelScope"> The Cloud HSM Cluster's auto-generated Domain Name Label Scope. </param>
        /// <param name="hsms"> An array of Cloud HSM Cluster's HSMs. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connection resources. </param>
        /// <param name="provisioningState"> The Cloud HSM Cluster's provisioningState. </param>
        /// <param name="publicNetworkAccess"> The Cloud HSM Cluster public network access. </param>
        /// <param name="statusMessage"> Cloud HSM Cluster status message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudHsmClusterProperties(SecurityDomainActivationState? activationState, AutoGeneratedDomainNameLabelScope? autoGeneratedDomainNameLabelScope, IReadOnlyList<CloudHsmProperties> hsms, IReadOnlyList<CloudHsmClusterPrivateEndpointConnectionData> privateEndpointConnections, CloudHsmClusterProvisioningState? provisioningState, CloudHsmClusterPublicNetworkAccess? publicNetworkAccess, string statusMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActivationState = activationState;
            AutoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
            Hsms = hsms;
            PrivateEndpointConnections = privateEndpointConnections;
            ProvisioningState = provisioningState;
            PublicNetworkAccess = publicNetworkAccess;
            StatusMessage = statusMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of security domain activation. </summary>
        [WirePath("activationState")]
        public SecurityDomainActivationState? ActivationState { get; }
        /// <summary> The Cloud HSM Cluster's auto-generated Domain Name Label Scope. </summary>
        [WirePath("autoGeneratedDomainNameLabelScope")]
        public AutoGeneratedDomainNameLabelScope? AutoGeneratedDomainNameLabelScope { get; set; }
        /// <summary> An array of Cloud HSM Cluster's HSMs. </summary>
        [WirePath("hsms")]
        public IReadOnlyList<CloudHsmProperties> Hsms { get; }
        /// <summary> List of private endpoint connection resources. </summary>
        [WirePath("privateEndpointConnections")]
        public IReadOnlyList<CloudHsmClusterPrivateEndpointConnectionData> PrivateEndpointConnections { get; }
        /// <summary> The Cloud HSM Cluster's provisioningState. </summary>
        [WirePath("provisioningState")]
        public CloudHsmClusterProvisioningState? ProvisioningState { get; }
        /// <summary> The Cloud HSM Cluster public network access. </summary>
        [WirePath("publicNetworkAccess")]
        public CloudHsmClusterPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> Cloud HSM Cluster status message. </summary>
        [WirePath("statusMessage")]
        public string StatusMessage { get; }
    }
}
