// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct CloudHsmClusterPrivateEndpointConnectionProvisioningState : IEquatable<CloudHsmClusterPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudHsmClusterPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string UpdatingValue = "Updating";
        private const string InternalErrorValue = "InternalError";
        private const string CanceledValue = "Canceled";

        /// <summary> Succeeded. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Succeeded { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Creating { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Deleting { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Failed { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Updating. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Updating { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(UpdatingValue);
        /// <summary> InternalError. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState InternalError { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(InternalErrorValue);
        /// <summary> Canceled. </summary>
        public static CloudHsmClusterPrivateEndpointConnectionProvisioningState Canceled { get; } = new CloudHsmClusterPrivateEndpointConnectionProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="CloudHsmClusterPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CloudHsmClusterPrivateEndpointConnectionProvisioningState left, CloudHsmClusterPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudHsmClusterPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CloudHsmClusterPrivateEndpointConnectionProvisioningState left, CloudHsmClusterPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudHsmClusterPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator CloudHsmClusterPrivateEndpointConnectionProvisioningState(string value) => new CloudHsmClusterPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudHsmClusterPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudHsmClusterPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
