// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> Properties of the Cloud HSM Cluster. </summary>
    public partial class CloudHsmClusterBackupResultProperties : BackupRestoreBaseResultProperties
    {
        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterBackupResultProperties"/>. </summary>
        internal CloudHsmClusterBackupResultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CloudHsmClusterBackupResultProperties"/>. </summary>
        /// <param name="status"> Status of the backup/restore operation. </param>
        /// <param name="statusDetails"> The status details of backup/restore operation. </param>
        /// <param name="error"> Error encountered, if any, during the backup/restore operation. </param>
        /// <param name="startOn"> The start time of the backup/restore operation in UTC. </param>
        /// <param name="endOn"> The end time of the backup/restore operation in UTC. </param>
        /// <param name="jobId"> Identifier for the backup/restore operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="azureStorageBlobContainerUri"> The Azure blob storage container Uri which contains the backup. </param>
        /// <param name="backupId"> The ID of the backup. </param>
        internal CloudHsmClusterBackupResultProperties(BackupRestoreOperationStatus? status, string statusDetails, ResponseError error, DateTimeOffset? startOn, DateTimeOffset? endOn, string jobId, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri azureStorageBlobContainerUri, string backupId) : base(status, statusDetails, error, startOn, endOn, jobId, serializedAdditionalRawData)
        {
            AzureStorageBlobContainerUri = azureStorageBlobContainerUri;
            BackupId = backupId;
        }

        /// <summary> The Azure blob storage container Uri which contains the backup. </summary>
        [WirePath("azureStorageBlobContainerUri")]
        public Uri AzureStorageBlobContainerUri { get; }
        /// <summary> The ID of the backup. </summary>
        [WirePath("backupId")]
        public string BackupId { get; }
    }
}
