// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> Backup and Restore Common properties. </summary>
    public partial class BackupRestoreRequestBaseProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupRestoreRequestBaseProperties"/>. </summary>
        /// <param name="azureStorageBlobContainerUri"> The Azure blob storage container Uri which contains the backup. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureStorageBlobContainerUri"/> is null. </exception>
        public BackupRestoreRequestBaseProperties(Uri azureStorageBlobContainerUri)
        {
            Argument.AssertNotNull(azureStorageBlobContainerUri, nameof(azureStorageBlobContainerUri));

            AzureStorageBlobContainerUri = azureStorageBlobContainerUri;
        }

        /// <summary> Initializes a new instance of <see cref="BackupRestoreRequestBaseProperties"/>. </summary>
        /// <param name="azureStorageBlobContainerUri"> The Azure blob storage container Uri which contains the backup. </param>
        /// <param name="token"> The SAS token pointing to an Azure blob storage container. This property is reserved for Azure Backup Service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupRestoreRequestBaseProperties(Uri azureStorageBlobContainerUri, string token, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureStorageBlobContainerUri = azureStorageBlobContainerUri;
            Token = token;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BackupRestoreRequestBaseProperties"/> for deserialization. </summary>
        internal BackupRestoreRequestBaseProperties()
        {
        }

        /// <summary> The Azure blob storage container Uri which contains the backup. </summary>
        [WirePath("azureStorageBlobContainerUri")]
        public Uri AzureStorageBlobContainerUri { get; }
        /// <summary> The SAS token pointing to an Azure blob storage container. This property is reserved for Azure Backup Service. </summary>
        [WirePath("token")]
        public string Token { get; set; }
    }
}
