// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> Status of the backup/restore operation. </summary>
    public readonly partial struct BackupRestoreOperationStatus : IEquatable<BackupRestoreOperationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupRestoreOperationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupRestoreOperationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CancelledValue = "Cancelled";

        /// <summary> InProgress. </summary>
        public static BackupRestoreOperationStatus InProgress { get; } = new BackupRestoreOperationStatus(InProgressValue);
        /// <summary> Succeeded. </summary>
        public static BackupRestoreOperationStatus Succeeded { get; } = new BackupRestoreOperationStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static BackupRestoreOperationStatus Failed { get; } = new BackupRestoreOperationStatus(FailedValue);
        /// <summary> Cancelled. </summary>
        public static BackupRestoreOperationStatus Cancelled { get; } = new BackupRestoreOperationStatus(CancelledValue);
        /// <summary> Determines if two <see cref="BackupRestoreOperationStatus"/> values are the same. </summary>
        public static bool operator ==(BackupRestoreOperationStatus left, BackupRestoreOperationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupRestoreOperationStatus"/> values are not the same. </summary>
        public static bool operator !=(BackupRestoreOperationStatus left, BackupRestoreOperationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupRestoreOperationStatus"/>. </summary>
        public static implicit operator BackupRestoreOperationStatus(string value) => new BackupRestoreOperationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupRestoreOperationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupRestoreOperationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
