// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HardwareSecurityModules.Models
{
    /// <summary> Backup and Restore operation common properties. </summary>
    public partial class BackupRestoreBaseResultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupRestoreBaseResultProperties"/>. </summary>
        internal BackupRestoreBaseResultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupRestoreBaseResultProperties"/>. </summary>
        /// <param name="status"> Status of the backup/restore operation. </param>
        /// <param name="statusDetails"> The status details of backup/restore operation. </param>
        /// <param name="error"> Error encountered, if any, during the backup/restore operation. </param>
        /// <param name="startOn"> The start time of the backup/restore operation in UTC. </param>
        /// <param name="endOn"> The end time of the backup/restore operation in UTC. </param>
        /// <param name="jobId"> Identifier for the backup/restore operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupRestoreBaseResultProperties(BackupRestoreOperationStatus? status, string statusDetails, ResponseError error, DateTimeOffset? startOn, DateTimeOffset? endOn, string jobId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            StatusDetails = statusDetails;
            Error = error;
            StartOn = startOn;
            EndOn = endOn;
            JobId = jobId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Status of the backup/restore operation. </summary>
        [WirePath("status")]
        public BackupRestoreOperationStatus? Status { get; }
        /// <summary> The status details of backup/restore operation. </summary>
        [WirePath("statusDetails")]
        public string StatusDetails { get; }
        /// <summary> Error encountered, if any, during the backup/restore operation. </summary>
        [WirePath("error")]
        public ResponseError Error { get; }
        /// <summary> The start time of the backup/restore operation in UTC. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> The end time of the backup/restore operation in UTC. </summary>
        [WirePath("endTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary> Identifier for the backup/restore operation. </summary>
        [WirePath("jobId")]
        public string JobId { get; }
    }
}
