// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HardwareSecurityModules
{
    internal class DedicatedHsmOperationSource : IOperationSource<DedicatedHsmResource>
    {
        private readonly ArmClient _client;

        internal DedicatedHsmOperationSource(ArmClient client)
        {
            _client = client;
        }

        DedicatedHsmResource IOperationSource<DedicatedHsmResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DedicatedHsmData.DeserializeDedicatedHsmData(document.RootElement);
            return new DedicatedHsmResource(_client, data);
        }

        async ValueTask<DedicatedHsmResource> IOperationSource<DedicatedHsmResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DedicatedHsmData.DeserializeDedicatedHsmData(document.RootElement);
            return new DedicatedHsmResource(_client, data);
        }
    }
}
