// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.HardwareSecurityModules.Models;

namespace Azure.ResourceManager.HardwareSecurityModules
{
    internal class CloudHsmClusterRestoreResultOperationSource : IOperationSource<CloudHsmClusterRestoreResult>
    {
        CloudHsmClusterRestoreResult IOperationSource<CloudHsmClusterRestoreResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return CloudHsmClusterRestoreResult.DeserializeCloudHsmClusterRestoreResult(document.RootElement);
        }

        async ValueTask<CloudHsmClusterRestoreResult> IOperationSource<CloudHsmClusterRestoreResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return CloudHsmClusterRestoreResult.DeserializeCloudHsmClusterRestoreResult(document.RootElement);
        }
    }
}
