// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HardwareSecurityModules
{
    internal class CloudHsmClusterOperationSource : IOperationSource<CloudHsmClusterResource>
    {
        private readonly ArmClient _client;

        internal CloudHsmClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        CloudHsmClusterResource IOperationSource<CloudHsmClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CloudHsmClusterData.DeserializeCloudHsmClusterData(document.RootElement);
            return new CloudHsmClusterResource(_client, data);
        }

        async ValueTask<CloudHsmClusterResource> IOperationSource<CloudHsmClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CloudHsmClusterData.DeserializeCloudHsmClusterData(document.RootElement);
            return new CloudHsmClusterResource(_client, data);
        }
    }
}
