// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.HardwareSecurityModules.Models;

namespace Azure.ResourceManager.HardwareSecurityModules
{
    internal class CloudHsmClusterBackupResultOperationSource : IOperationSource<CloudHsmClusterBackupResult>
    {
        CloudHsmClusterBackupResult IOperationSource<CloudHsmClusterBackupResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return CloudHsmClusterBackupResult.DeserializeCloudHsmClusterBackupResult(document.RootElement);
        }

        async ValueTask<CloudHsmClusterBackupResult> IOperationSource<CloudHsmClusterBackupResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return CloudHsmClusterBackupResult.DeserializeCloudHsmClusterBackupResult(document.RootElement);
        }
    }
}
