// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.HardwareSecurityModules.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HardwareSecurityModules
{
    /// <summary>
    /// A class representing the DedicatedHsm data model.
    /// Resource information with extended details.
    /// </summary>
    public partial class DedicatedHsmData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> SKU details. </param>
        /// <param name="properties"> Properties of the dedicated HSM. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/> or <paramref name="properties"/> is null. </exception>
        public DedicatedHsmData(AzureLocation location, DedicatedHsmSku sku, DedicatedHsmProperties properties) : base(location)
        {
            Argument.AssertNotNull(sku, nameof(sku));
            Argument.AssertNotNull(properties, nameof(properties));

            Sku = sku;
            Zones = new ChangeTrackingList<string>();
            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> SKU details. </param>
        /// <param name="zones"> The Dedicated Hsm zones. </param>
        /// <param name="properties"> Properties of the dedicated HSM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DedicatedHsmData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, DedicatedHsmSku sku, IList<string> zones, DedicatedHsmProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            Zones = zones;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedHsmData"/> for deserialization. </summary>
        internal DedicatedHsmData()
        {
        }

        /// <summary> SKU details. </summary>
        internal DedicatedHsmSku Sku { get; set; }
        /// <summary> SKU of the dedicated HSM. </summary>
        [WirePath("sku.name")]
        public DedicatedHsmSkuName? SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new DedicatedHsmSku();
                Sku.Name = value;
            }
        }

        /// <summary> The Dedicated Hsm zones. </summary>
        [WirePath("zones")]
        public IList<string> Zones { get; }
        /// <summary> Properties of the dedicated HSM. </summary>
        [WirePath("properties")]
        public DedicatedHsmProperties Properties { get; set; }
    }
}
