// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    public partial class LcmConfigurationSetting : IUtf8JsonSerializable, IJsonModel<LcmConfigurationSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LcmConfigurationSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LcmConfigurationSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LcmConfigurationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LcmConfigurationSetting)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ConfigurationMode))
            {
                writer.WritePropertyName("configurationMode"u8);
                writer.WriteStringValue(ConfigurationMode.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(IsModuleOverwriteAllowed))
            {
                writer.WritePropertyName("allowModuleOverwrite"u8);
                writer.WriteBooleanValue(IsModuleOverwriteAllowed.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ActionAfterReboot))
            {
                writer.WritePropertyName("actionAfterReboot"u8);
                writer.WriteStringValue(ActionAfterReboot.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RefreshFrequencyInMins))
            {
                writer.WritePropertyName("refreshFrequencyMins"u8);
                writer.WriteNumberValue(RefreshFrequencyInMins.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RebootIfNeeded))
            {
                writer.WritePropertyName("rebootIfNeeded"u8);
                writer.WriteBooleanValue(RebootIfNeeded.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ConfigurationModeFrequencyInMins))
            {
                writer.WritePropertyName("configurationModeFrequencyMins"u8);
                writer.WriteNumberValue(ConfigurationModeFrequencyInMins.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LcmConfigurationSetting IJsonModel<LcmConfigurationSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LcmConfigurationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LcmConfigurationSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLcmConfigurationSetting(document.RootElement, options);
        }

        internal static LcmConfigurationSetting DeserializeLcmConfigurationSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LcmConfigurationMode? configurationMode = default;
            bool? allowModuleOverwrite = default;
            ActionAfterReboot? actionAfterReboot = default;
            float? refreshFrequencyMins = default;
            bool? rebootIfNeeded = default;
            float? configurationModeFrequencyMins = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("configurationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    configurationMode = new LcmConfigurationMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("allowModuleOverwrite"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowModuleOverwrite = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("actionAfterReboot"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    actionAfterReboot = new ActionAfterReboot(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("refreshFrequencyMins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    refreshFrequencyMins = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("rebootIfNeeded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebootIfNeeded = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("configurationModeFrequencyMins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    configurationModeFrequencyMins = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LcmConfigurationSetting(
                configurationMode,
                allowModuleOverwrite,
                actionAfterReboot,
                refreshFrequencyMins,
                rebootIfNeeded,
                configurationModeFrequencyMins,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConfigurationMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  configurationMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConfigurationMode))
                {
                    builder.Append("  configurationMode: ");
                    builder.AppendLine($"'{ConfigurationMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsModuleOverwriteAllowed), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allowModuleOverwrite: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsModuleOverwriteAllowed))
                {
                    builder.Append("  allowModuleOverwrite: ");
                    var boolValue = IsModuleOverwriteAllowed.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ActionAfterReboot), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  actionAfterReboot: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ActionAfterReboot))
                {
                    builder.Append("  actionAfterReboot: ");
                    builder.AppendLine($"'{ActionAfterReboot.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefreshFrequencyInMins), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refreshFrequencyMins: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefreshFrequencyInMins))
                {
                    builder.Append("  refreshFrequencyMins: ");
                    builder.AppendLine($"'{RefreshFrequencyInMins.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RebootIfNeeded), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rebootIfNeeded: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RebootIfNeeded))
                {
                    builder.Append("  rebootIfNeeded: ");
                    var boolValue = RebootIfNeeded.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConfigurationModeFrequencyInMins), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  configurationModeFrequencyMins: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConfigurationModeFrequencyInMins))
                {
                    builder.Append("  configurationModeFrequencyMins: ");
                    builder.AppendLine($"'{ConfigurationModeFrequencyInMins.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<LcmConfigurationSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LcmConfigurationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(LcmConfigurationSetting)} does not support writing '{options.Format}' format.");
            }
        }

        LcmConfigurationSetting IPersistableModel<LcmConfigurationSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LcmConfigurationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLcmConfigurationSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LcmConfigurationSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LcmConfigurationSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
