// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    /// <summary> Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect. </summary>
    public readonly partial struct LcmConfigurationMode : IEquatable<LcmConfigurationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LcmConfigurationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LcmConfigurationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplyOnlyValue = "ApplyOnly";
        private const string ApplyAndMonitorValue = "ApplyAndMonitor";
        private const string ApplyAndAutoCorrectValue = "ApplyAndAutoCorrect";

        /// <summary> ApplyOnly. </summary>
        public static LcmConfigurationMode ApplyOnly { get; } = new LcmConfigurationMode(ApplyOnlyValue);
        /// <summary> ApplyAndMonitor. </summary>
        public static LcmConfigurationMode ApplyAndMonitor { get; } = new LcmConfigurationMode(ApplyAndMonitorValue);
        /// <summary> ApplyAndAutoCorrect. </summary>
        public static LcmConfigurationMode ApplyAndAutoCorrect { get; } = new LcmConfigurationMode(ApplyAndAutoCorrectValue);
        /// <summary> Determines if two <see cref="LcmConfigurationMode"/> values are the same. </summary>
        public static bool operator ==(LcmConfigurationMode left, LcmConfigurationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LcmConfigurationMode"/> values are not the same. </summary>
        public static bool operator !=(LcmConfigurationMode left, LcmConfigurationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LcmConfigurationMode"/>. </summary>
        public static implicit operator LcmConfigurationMode(string value) => new LcmConfigurationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LcmConfigurationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LcmConfigurationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
