// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    /// <summary> Information about VMSS VM. </summary>
    public partial class GuestConfigurationVmssVmInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GuestConfigurationVmssVmInfo"/>. </summary>
        public GuestConfigurationVmssVmInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GuestConfigurationVmssVmInfo"/>. </summary>
        /// <param name="vmId"> UUID of the VM. </param>
        /// <param name="vmResourceId"> Azure resource Id of the VM. </param>
        /// <param name="complianceStatus"> A value indicating compliance status of the machine for the assigned guest configuration. </param>
        /// <param name="latestReportId"> Id of the latest report for the guest configuration assignment. </param>
        /// <param name="lastComplianceCheckedOn"> Date and time when last compliance status was checked. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GuestConfigurationVmssVmInfo(Guid? vmId, ResourceIdentifier vmResourceId, AssignedGuestConfigurationMachineComplianceStatus? complianceStatus, Guid? latestReportId, DateTimeOffset? lastComplianceCheckedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmId = vmId;
            VmResourceId = vmResourceId;
            ComplianceStatus = complianceStatus;
            LatestReportId = latestReportId;
            LastComplianceCheckedOn = lastComplianceCheckedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> UUID of the VM. </summary>
        [WirePath("vmId")]
        public Guid? VmId { get; }
        /// <summary> Azure resource Id of the VM. </summary>
        [WirePath("vmResourceId")]
        public ResourceIdentifier VmResourceId { get; }
        /// <summary> A value indicating compliance status of the machine for the assigned guest configuration. </summary>
        [WirePath("complianceStatus")]
        public AssignedGuestConfigurationMachineComplianceStatus? ComplianceStatus { get; }
        /// <summary> Id of the latest report for the guest configuration assignment. </summary>
        [WirePath("latestReportId")]
        public Guid? LatestReportId { get; }
        /// <summary> Date and time when last compliance status was checked. </summary>
        [WirePath("lastComplianceChecked")]
        public DateTimeOffset? LastComplianceCheckedOn { get; }
    }
}
