// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    /// <summary> The provisioning state, which only appears in the response. </summary>
    public readonly partial struct GuestConfigurationProvisioningState : IEquatable<GuestConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GuestConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GuestConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatedValue = "Created";

        /// <summary> Succeeded. </summary>
        public static GuestConfigurationProvisioningState Succeeded { get; } = new GuestConfigurationProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static GuestConfigurationProvisioningState Failed { get; } = new GuestConfigurationProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static GuestConfigurationProvisioningState Canceled { get; } = new GuestConfigurationProvisioningState(CanceledValue);
        /// <summary> Created. </summary>
        public static GuestConfigurationProvisioningState Created { get; } = new GuestConfigurationProvisioningState(CreatedValue);
        /// <summary> Determines if two <see cref="GuestConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(GuestConfigurationProvisioningState left, GuestConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GuestConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(GuestConfigurationProvisioningState left, GuestConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GuestConfigurationProvisioningState"/>. </summary>
        public static implicit operator GuestConfigurationProvisioningState(string value) => new GuestConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GuestConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GuestConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
