// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    /// <summary> Report for the guest configuration assignment. Report contains information such as compliance status, reason, and more. </summary>
    public partial class GuestConfigurationAssignmentReportProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GuestConfigurationAssignmentReportProperties"/>. </summary>
        internal GuestConfigurationAssignmentReportProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GuestConfigurationAssignmentReportProperties"/>. </summary>
        /// <param name="complianceStatus"> A value indicating compliance status of the machine for the assigned guest configuration. </param>
        /// <param name="reportId"> GUID that identifies the guest configuration assignment report under a subscription, resource group. </param>
        /// <param name="assignment"> Configuration details of the guest configuration assignment. </param>
        /// <param name="vm"> Information about the VM. </param>
        /// <param name="startOn"> Start date and time of the guest configuration assignment compliance status check. </param>
        /// <param name="endOn"> End date and time of the guest configuration assignment compliance status check. </param>
        /// <param name="details"> Details of the assignment report. </param>
        /// <param name="vmssResourceId"> Azure resource Id of the VMSS. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GuestConfigurationAssignmentReportProperties(AssignedGuestConfigurationMachineComplianceStatus? complianceStatus, Guid? reportId, GuestConfigurationAssignmentInfo assignment, GuestConfigurationVmInfo vm, DateTimeOffset? startOn, DateTimeOffset? endOn, GuestConfigurationAssignmentReportDetails details, string vmssResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ComplianceStatus = complianceStatus;
            ReportId = reportId;
            Assignment = assignment;
            Vm = vm;
            StartOn = startOn;
            EndOn = endOn;
            Details = details;
            VmssResourceId = vmssResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A value indicating compliance status of the machine for the assigned guest configuration. </summary>
        [WirePath("complianceStatus")]
        public AssignedGuestConfigurationMachineComplianceStatus? ComplianceStatus { get; }
        /// <summary> GUID that identifies the guest configuration assignment report under a subscription, resource group. </summary>
        [WirePath("reportId")]
        public Guid? ReportId { get; }
        /// <summary> Configuration details of the guest configuration assignment. </summary>
        [WirePath("assignment")]
        public GuestConfigurationAssignmentInfo Assignment { get; }
        /// <summary> Information about the VM. </summary>
        [WirePath("vm")]
        public GuestConfigurationVmInfo Vm { get; }
        /// <summary> Start date and time of the guest configuration assignment compliance status check. </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> End date and time of the guest configuration assignment compliance status check. </summary>
        [WirePath("endTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary> Details of the assignment report. </summary>
        [WirePath("details")]
        public GuestConfigurationAssignmentReportDetails Details { get; }
        /// <summary> Azure resource Id of the VMSS. </summary>
        [WirePath("vmssResourceId")]
        public string VmssResourceId { get; }
    }
}
