// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.GuestConfiguration.Models
{
    /// <summary> Reason and code for the compliance of the guest configuration assignment resource. </summary>
    public partial class AssignmentReportResourceComplianceReason
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssignmentReportResourceComplianceReason"/>. </summary>
        public AssignmentReportResourceComplianceReason()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AssignmentReportResourceComplianceReason"/>. </summary>
        /// <param name="phrase"> Reason for the compliance of the guest configuration assignment resource. </param>
        /// <param name="code"> Code for the compliance of the guest configuration assignment resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssignmentReportResourceComplianceReason(string phrase, string code, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Phrase = phrase;
            Code = code;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Reason for the compliance of the guest configuration assignment resource. </summary>
        [WirePath("phrase")]
        public string Phrase { get; }
        /// <summary> Code for the compliance of the guest configuration assignment resource. </summary>
        [WirePath("code")]
        public string Code { get; }
    }
}
