// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.GraphServices.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableGraphServicesArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableGraphServicesArmClient"/> class for mocking. </summary>
        protected MockableGraphServicesArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableGraphServicesArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableGraphServicesArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableGraphServicesArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="GraphServicesAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GraphServicesAccountResource.CreateResourceIdentifier" /> to create a <see cref="GraphServicesAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GraphServicesAccountResource"/> object. </returns>
        public virtual GraphServicesAccountResource GetGraphServicesAccountResource(ResourceIdentifier id)
        {
            GraphServicesAccountResource.ValidateResourceId(id);
            return new GraphServicesAccountResource(Client, id);
        }
    }
}
