// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The current billing term of the SaaS Subscription. </summary>
    public partial class SubscriptionTerm
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubscriptionTerm"/>. </summary>
        internal SubscriptionTerm()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SubscriptionTerm"/>. </summary>
        /// <param name="termUnit"> The unit of the billing term. </param>
        /// <param name="startOn"> The date and time in UTC of when the billing term starts. </param>
        /// <param name="endOn"> The date and time in UTC of when the billing term ends. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubscriptionTerm(string termUnit, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TermUnit = termUnit;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The unit of the billing term. </summary>
        public string TermUnit { get; }
        /// <summary> The date and time in UTC of when the billing term starts. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> The date and time in UTC of when the billing term ends. </summary>
        public DateTimeOffset? EndOn { get; }
    }
}
