// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary>
    /// Email server settings.
    /// https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp
    /// </summary>
    public partial class Smtp
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Smtp"/>. </summary>
        public Smtp()
        {
        }

        /// <summary> Initializes a new instance of <see cref="Smtp"/>. </summary>
        /// <param name="enabled"> Enable this to allow Grafana to send email. Default is false. </param>
        /// <param name="host"> SMTP server hostname with port, e.g. test.email.net:587. </param>
        /// <param name="user"> User of SMTP auth. </param>
        /// <param name="password"> Password of SMTP auth. If the password contains # or ;, then you have to wrap it with triple quotes. </param>
        /// <param name="fromAddress">
        /// Address used when sending out emails
        /// https://pkg.go.dev/net/mail#Address
        /// </param>
        /// <param name="fromName">
        /// Name to be used when sending out emails. Default is "Azure Managed Grafana Notification"
        /// https://pkg.go.dev/net/mail#Address
        /// </param>
        /// <param name="startTLSPolicy">
        /// The StartTLSPolicy setting of the SMTP configuration
        /// https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy
        /// </param>
        /// <param name="skipVerify">
        /// Verify SSL for SMTP server. Default is false
        /// https://pkg.go.dev/crypto/tls#Config
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Smtp(bool? enabled, string host, string user, string password, string fromAddress, string fromName, StartTLSPolicy? startTLSPolicy, bool? skipVerify, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Enabled = enabled;
            Host = host;
            User = user;
            Password = password;
            FromAddress = fromAddress;
            FromName = fromName;
            StartTLSPolicy = startTLSPolicy;
            SkipVerify = skipVerify;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Enable this to allow Grafana to send email. Default is false. </summary>
        public bool? Enabled { get; set; }
        /// <summary> SMTP server hostname with port, e.g. test.email.net:587. </summary>
        public string Host { get; set; }
        /// <summary> User of SMTP auth. </summary>
        public string User { get; set; }
        /// <summary> Password of SMTP auth. If the password contains # or ;, then you have to wrap it with triple quotes. </summary>
        public string Password { get; set; }
        /// <summary>
        /// Address used when sending out emails
        /// https://pkg.go.dev/net/mail#Address
        /// </summary>
        public string FromAddress { get; set; }
        /// <summary>
        /// Name to be used when sending out emails. Default is "Azure Managed Grafana Notification"
        /// https://pkg.go.dev/net/mail#Address
        /// </summary>
        public string FromName { get; set; }
        /// <summary>
        /// The StartTLSPolicy setting of the SMTP configuration
        /// https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy
        /// </summary>
        public StartTLSPolicy? StartTLSPolicy { get; set; }
        /// <summary>
        /// Verify SSL for SMTP server. Default is false
        /// https://pkg.go.dev/crypto/tls#Config
        /// </summary>
        public bool? SkipVerify { get; set; }
    }
}
