// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Grafana.Models
{
    public partial class Smtp : IUtf8JsonSerializable, IJsonModel<Smtp>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<Smtp>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<Smtp>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Smtp>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Smtp)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Enabled))
            {
                writer.WritePropertyName("enabled"u8);
                writer.WriteBooleanValue(Enabled.Value);
            }
            if (Optional.IsDefined(Host))
            {
                writer.WritePropertyName("host"u8);
                writer.WriteStringValue(Host);
            }
            if (Optional.IsDefined(User))
            {
                writer.WritePropertyName("user"u8);
                writer.WriteStringValue(User);
            }
            if (Optional.IsDefined(Password))
            {
                writer.WritePropertyName("password"u8);
                writer.WriteStringValue(Password);
            }
            if (Optional.IsDefined(FromAddress))
            {
                writer.WritePropertyName("fromAddress"u8);
                writer.WriteStringValue(FromAddress);
            }
            if (Optional.IsDefined(FromName))
            {
                writer.WritePropertyName("fromName"u8);
                writer.WriteStringValue(FromName);
            }
            if (Optional.IsDefined(StartTLSPolicy))
            {
                writer.WritePropertyName("startTLSPolicy"u8);
                writer.WriteStringValue(StartTLSPolicy.Value.ToString());
            }
            if (Optional.IsDefined(SkipVerify))
            {
                writer.WritePropertyName("skipVerify"u8);
                writer.WriteBooleanValue(SkipVerify.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        Smtp IJsonModel<Smtp>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Smtp>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Smtp)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSmtp(document.RootElement, options);
        }

        internal static Smtp DeserializeSmtp(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? enabled = default;
            string host = default;
            string user = default;
            string password = default;
            string fromAddress = default;
            string fromName = default;
            StartTLSPolicy? startTLSPolicy = default;
            bool? skipVerify = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("host"u8))
                {
                    host = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("user"u8))
                {
                    user = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("password"u8))
                {
                    password = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fromAddress"u8))
                {
                    fromAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fromName"u8))
                {
                    fromName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTLSPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTLSPolicy = new StartTLSPolicy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("skipVerify"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    skipVerify = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new Smtp(
                enabled,
                host,
                user,
                password,
                fromAddress,
                fromName,
                startTLSPolicy,
                skipVerify,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<Smtp>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Smtp>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(Smtp)} does not support writing '{options.Format}' format.");
            }
        }

        Smtp IPersistableModel<Smtp>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Smtp>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSmtp(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(Smtp)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<Smtp>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
