// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> SaaS subscription details of a Grafana instance. </summary>
    public partial class SaasSubscriptionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SaasSubscriptionDetails"/>. </summary>
        internal SaasSubscriptionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SaasSubscriptionDetails"/>. </summary>
        /// <param name="planId"> The plan Id of the SaaS subscription. </param>
        /// <param name="offerId"> The offer Id of the SaaS subscription. </param>
        /// <param name="publisherId"> The publisher Id of the SaaS subscription. </param>
        /// <param name="term"> The billing term of the SaaS Subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SaasSubscriptionDetails(string planId, string offerId, string publisherId, SubscriptionTerm term, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PlanId = planId;
            OfferId = offerId;
            PublisherId = publisherId;
            Term = term;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The plan Id of the SaaS subscription. </summary>
        public string PlanId { get; }
        /// <summary> The offer Id of the SaaS subscription. </summary>
        public string OfferId { get; }
        /// <summary> The publisher Id of the SaaS subscription. </summary>
        public string PublisherId { get; }
        /// <summary> The billing term of the SaaS Subscription. </summary>
        public SubscriptionTerm Term { get; }
    }
}
