// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The AutoRenew setting of the Enterprise subscription. </summary>
    public readonly partial struct MarketplaceAutoRenew : IEquatable<MarketplaceAutoRenew>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MarketplaceAutoRenew"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MarketplaceAutoRenew(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static MarketplaceAutoRenew Disabled { get; } = new MarketplaceAutoRenew(DisabledValue);
        /// <summary> Enabled. </summary>
        public static MarketplaceAutoRenew Enabled { get; } = new MarketplaceAutoRenew(EnabledValue);
        /// <summary> Determines if two <see cref="MarketplaceAutoRenew"/> values are the same. </summary>
        public static bool operator ==(MarketplaceAutoRenew left, MarketplaceAutoRenew right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MarketplaceAutoRenew"/> values are not the same. </summary>
        public static bool operator !=(MarketplaceAutoRenew left, MarketplaceAutoRenew right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MarketplaceAutoRenew"/>. </summary>
        public static implicit operator MarketplaceAutoRenew(string value) => new MarketplaceAutoRenew(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MarketplaceAutoRenew other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MarketplaceAutoRenew other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
