// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The GrafanaZoneRedundancy. </summary>
    public readonly partial struct GrafanaZoneRedundancy : IEquatable<GrafanaZoneRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GrafanaZoneRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GrafanaZoneRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static GrafanaZoneRedundancy Disabled { get; } = new GrafanaZoneRedundancy(DisabledValue);
        /// <summary> Enabled. </summary>
        public static GrafanaZoneRedundancy Enabled { get; } = new GrafanaZoneRedundancy(EnabledValue);
        /// <summary> Determines if two <see cref="GrafanaZoneRedundancy"/> values are the same. </summary>
        public static bool operator ==(GrafanaZoneRedundancy left, GrafanaZoneRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GrafanaZoneRedundancy"/> values are not the same. </summary>
        public static bool operator !=(GrafanaZoneRedundancy left, GrafanaZoneRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GrafanaZoneRedundancy"/>. </summary>
        public static implicit operator GrafanaZoneRedundancy(string value) => new GrafanaZoneRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GrafanaZoneRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GrafanaZoneRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
