// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The GrafanaProvisioningState. </summary>
    public readonly partial struct GrafanaProvisioningState : IEquatable<GrafanaProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GrafanaProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GrafanaProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Accepted. </summary>
        public static GrafanaProvisioningState Accepted { get; } = new GrafanaProvisioningState(AcceptedValue);
        /// <summary> Creating. </summary>
        public static GrafanaProvisioningState Creating { get; } = new GrafanaProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static GrafanaProvisioningState Updating { get; } = new GrafanaProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static GrafanaProvisioningState Deleting { get; } = new GrafanaProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static GrafanaProvisioningState Succeeded { get; } = new GrafanaProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static GrafanaProvisioningState Failed { get; } = new GrafanaProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static GrafanaProvisioningState Canceled { get; } = new GrafanaProvisioningState(CanceledValue);
        /// <summary> Deleted. </summary>
        public static GrafanaProvisioningState Deleted { get; } = new GrafanaProvisioningState(DeletedValue);
        /// <summary> NotSpecified. </summary>
        public static GrafanaProvisioningState NotSpecified { get; } = new GrafanaProvisioningState(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="GrafanaProvisioningState"/> values are the same. </summary>
        public static bool operator ==(GrafanaProvisioningState left, GrafanaProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GrafanaProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(GrafanaProvisioningState left, GrafanaProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GrafanaProvisioningState"/>. </summary>
        public static implicit operator GrafanaProvisioningState(string value) => new GrafanaProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GrafanaProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GrafanaProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
