// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct GrafanaPrivateEndpointConnectionProvisioningState : IEquatable<GrafanaPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GrafanaPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GrafanaPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static GrafanaPrivateEndpointConnectionProvisioningState Succeeded { get; } = new GrafanaPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static GrafanaPrivateEndpointConnectionProvisioningState Creating { get; } = new GrafanaPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static GrafanaPrivateEndpointConnectionProvisioningState Deleting { get; } = new GrafanaPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static GrafanaPrivateEndpointConnectionProvisioningState Failed { get; } = new GrafanaPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="GrafanaPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(GrafanaPrivateEndpointConnectionProvisioningState left, GrafanaPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GrafanaPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(GrafanaPrivateEndpointConnectionProvisioningState left, GrafanaPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GrafanaPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator GrafanaPrivateEndpointConnectionProvisioningState(string value) => new GrafanaPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GrafanaPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GrafanaPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
