// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The GrafanaApiKey. </summary>
    public readonly partial struct GrafanaApiKey : IEquatable<GrafanaApiKey>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GrafanaApiKey"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GrafanaApiKey(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static GrafanaApiKey Disabled { get; } = new GrafanaApiKey(DisabledValue);
        /// <summary> Enabled. </summary>
        public static GrafanaApiKey Enabled { get; } = new GrafanaApiKey(EnabledValue);
        /// <summary> Determines if two <see cref="GrafanaApiKey"/> values are the same. </summary>
        public static bool operator ==(GrafanaApiKey left, GrafanaApiKey right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GrafanaApiKey"/> values are not the same. </summary>
        public static bool operator !=(GrafanaApiKey left, GrafanaApiKey right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GrafanaApiKey"/>. </summary>
        public static implicit operator GrafanaApiKey(string value) => new GrafanaApiKey(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GrafanaApiKey other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GrafanaApiKey other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
