// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> Enterprise details of a Grafana instance. </summary>
    public partial class EnterpriseDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EnterpriseDetails"/>. </summary>
        internal EnterpriseDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EnterpriseDetails"/>. </summary>
        /// <param name="saasSubscriptionDetails"> SaaS subscription details of a Grafana instance. </param>
        /// <param name="marketplaceTrialQuota"> The allocation details of the per subscription free trial slot of the subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EnterpriseDetails(SaasSubscriptionDetails saasSubscriptionDetails, MarketplaceTrialQuota marketplaceTrialQuota, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SaasSubscriptionDetails = saasSubscriptionDetails;
            MarketplaceTrialQuota = marketplaceTrialQuota;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SaaS subscription details of a Grafana instance. </summary>
        public SaasSubscriptionDetails SaasSubscriptionDetails { get; }
        /// <summary> The allocation details of the per subscription free trial slot of the subscription. </summary>
        public MarketplaceTrialQuota MarketplaceTrialQuota { get; }
    }
}
