// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> The DeterministicOutboundIP. </summary>
    public readonly partial struct DeterministicOutboundIP : IEquatable<DeterministicOutboundIP>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeterministicOutboundIP"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeterministicOutboundIP(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static DeterministicOutboundIP Disabled { get; } = new DeterministicOutboundIP(DisabledValue);
        /// <summary> Enabled. </summary>
        public static DeterministicOutboundIP Enabled { get; } = new DeterministicOutboundIP(EnabledValue);
        /// <summary> Determines if two <see cref="DeterministicOutboundIP"/> values are the same. </summary>
        public static bool operator ==(DeterministicOutboundIP left, DeterministicOutboundIP right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeterministicOutboundIP"/> values are not the same. </summary>
        public static bool operator !=(DeterministicOutboundIP left, DeterministicOutboundIP right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeterministicOutboundIP"/>. </summary>
        public static implicit operator DeterministicOutboundIP(string value) => new DeterministicOutboundIP(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeterministicOutboundIP other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeterministicOutboundIP other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
