// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Grafana
{
    internal class ManagedGrafanaOperationSource : IOperationSource<ManagedGrafanaResource>
    {
        private readonly ArmClient _client;

        internal ManagedGrafanaOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedGrafanaResource IOperationSource<ManagedGrafanaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedGrafanaData.DeserializeManagedGrafanaData(document.RootElement);
            return new ManagedGrafanaResource(_client, data);
        }

        async ValueTask<ManagedGrafanaResource> IOperationSource<ManagedGrafanaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedGrafanaData.DeserializeManagedGrafanaData(document.RootElement);
            return new ManagedGrafanaResource(_client, data);
        }
    }
}
