// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Grafana
{
    internal class GrafanaPrivateEndpointConnectionOperationSource : IOperationSource<GrafanaPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal GrafanaPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        GrafanaPrivateEndpointConnectionResource IOperationSource<GrafanaPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GrafanaPrivateEndpointConnectionData.DeserializeGrafanaPrivateEndpointConnectionData(document.RootElement);
            return new GrafanaPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<GrafanaPrivateEndpointConnectionResource> IOperationSource<GrafanaPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GrafanaPrivateEndpointConnectionData.DeserializeGrafanaPrivateEndpointConnectionData(document.RootElement);
            return new GrafanaPrivateEndpointConnectionResource(_client, data);
        }
    }
}
