// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Grafana.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableGrafanaArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableGrafanaArmClient"/> class for mocking. </summary>
        protected MockableGrafanaArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableGrafanaArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableGrafanaArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableGrafanaArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedGrafanaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedGrafanaResource.CreateResourceIdentifier" /> to create a <see cref="ManagedGrafanaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedGrafanaResource"/> object. </returns>
        public virtual ManagedGrafanaResource GetManagedGrafanaResource(ResourceIdentifier id)
        {
            ManagedGrafanaResource.ValidateResourceId(id);
            return new ManagedGrafanaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GrafanaPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GrafanaPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="GrafanaPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GrafanaPrivateEndpointConnectionResource"/> object. </returns>
        public virtual GrafanaPrivateEndpointConnectionResource GetGrafanaPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            GrafanaPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new GrafanaPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GrafanaPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GrafanaPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="GrafanaPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GrafanaPrivateLinkResource"/> object. </returns>
        public virtual GrafanaPrivateLinkResource GetGrafanaPrivateLinkResource(ResourceIdentifier id)
        {
            GrafanaPrivateLinkResource.ValidateResourceId(id);
            return new GrafanaPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ManagedPrivateEndpointModelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ManagedPrivateEndpointModelResource.CreateResourceIdentifier" /> to create a <see cref="ManagedPrivateEndpointModelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ManagedPrivateEndpointModelResource"/> object. </returns>
        public virtual ManagedPrivateEndpointModelResource GetManagedPrivateEndpointModelResource(ResourceIdentifier id)
        {
            ManagedPrivateEndpointModelResource.ValidateResourceId(id);
            return new ManagedPrivateEndpointModelResource(Client, id);
        }
    }
}
