// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Grafana.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmGrafanaModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Grafana.ManagedGrafanaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The Sku of the grafana resource. </param>
        /// <param name="properties"> Properties specific to the grafana resource. </param>
        /// <param name="identity"> The managed identity of the grafana resource. </param>
        /// <returns> A new <see cref="Grafana.ManagedGrafanaData"/> instance for mocking. </returns>
        public static ManagedGrafanaData ManagedGrafanaData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string skuName = null, ManagedGrafanaProperties properties = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ManagedGrafanaData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                skuName != null ? new ManagedGrafanaSku(skuName, serializedAdditionalRawData: null) : null,
                properties,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedGrafanaProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="grafanaVersion"> The Grafana software version. </param>
        /// <param name="endpoint"> The endpoint of the Grafana instance. </param>
        /// <param name="publicNetworkAccess"> Indicate the state for enable or disable traffic over the public interface. </param>
        /// <param name="zoneRedundancy"> The zone redundancy setting of the Grafana instance. </param>
        /// <param name="apiKey"> The api key setting of the Grafana instance. </param>
        /// <param name="deterministicOutboundIP"> Whether a Grafana instance uses deterministic outbound IPs. </param>
        /// <param name="outboundIPs"> List of outbound IPs if deterministicOutboundIP is enabled. </param>
        /// <param name="privateEndpointConnections"> The private endpoint connections of the Grafana instance. </param>
        /// <param name="autoGeneratedDomainNameLabelScope"> Scope for dns deterministic name hash calculation. </param>
        /// <param name="monitorWorkspaceIntegrations"> GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios. </param>
        /// <param name="enterpriseConfigurations"> Enterprise settings of a Grafana instance. </param>
        /// <param name="grafanaConfigurationsSmtp"> Server configurations of a Grafana instance. </param>
        /// <param name="grafanaPlugins"> Installed plugin list of the Grafana instance. Key is plugin id, value is plugin definition. </param>
        /// <param name="grafanaMajorVersion"> The major Grafana software version to target. </param>
        /// <returns> A new <see cref="Models.ManagedGrafanaProperties"/> instance for mocking. </returns>
        public static ManagedGrafanaProperties ManagedGrafanaProperties(GrafanaProvisioningState? provisioningState = null, string grafanaVersion = null, string endpoint = null, GrafanaPublicNetworkAccess? publicNetworkAccess = null, GrafanaZoneRedundancy? zoneRedundancy = null, GrafanaApiKey? apiKey = null, DeterministicOutboundIP? deterministicOutboundIP = null, IEnumerable<string> outboundIPs = null, IEnumerable<GrafanaPrivateEndpointConnectionData> privateEndpointConnections = null, AutoGeneratedDomainNameLabelScope? autoGeneratedDomainNameLabelScope = null, IEnumerable<MonitorWorkspaceIntegration> monitorWorkspaceIntegrations = null, EnterpriseConfigurations enterpriseConfigurations = null, Smtp grafanaConfigurationsSmtp = null, IDictionary<string, GrafanaPlugin> grafanaPlugins = null, string grafanaMajorVersion = null)
        {
            outboundIPs ??= new List<string>();
            privateEndpointConnections ??= new List<GrafanaPrivateEndpointConnectionData>();
            monitorWorkspaceIntegrations ??= new List<MonitorWorkspaceIntegration>();
            grafanaPlugins ??= new Dictionary<string, GrafanaPlugin>();

            return new ManagedGrafanaProperties(
                provisioningState,
                grafanaVersion,
                endpoint,
                publicNetworkAccess,
                zoneRedundancy,
                apiKey,
                deterministicOutboundIP,
                outboundIPs?.ToList(),
                privateEndpointConnections?.ToList(),
                autoGeneratedDomainNameLabelScope,
                monitorWorkspaceIntegrations != null ? new GrafanaIntegrations(monitorWorkspaceIntegrations?.ToList(), serializedAdditionalRawData: null) : null,
                enterpriseConfigurations,
                grafanaConfigurationsSmtp != null ? new GrafanaConfigurations(grafanaConfigurationsSmtp, serializedAdditionalRawData: null) : null,
                grafanaPlugins,
                grafanaMajorVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Grafana.GrafanaPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="groupIds"> The private endpoint connection group ids. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="Grafana.GrafanaPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static GrafanaPrivateEndpointConnectionData GrafanaPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, GrafanaPrivateLinkServiceConnectionState connectionState = null, IEnumerable<string> groupIds = null, GrafanaPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            groupIds ??= new List<string>();

            return new GrafanaPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                groupIds?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GrafanaPlugin"/>. </summary>
        /// <param name="pluginId"> Grafana plugin id. </param>
        /// <returns> A new <see cref="Models.GrafanaPlugin"/> instance for mocking. </returns>
        public static GrafanaPlugin GrafanaPlugin(string pluginId = null)
        {
            return new GrafanaPlugin(pluginId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Grafana.GrafanaPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Grafana.GrafanaPrivateLinkResourceData"/> instance for mocking. </returns>
        public static GrafanaPrivateLinkResourceData GrafanaPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, GrafanaProvisioningState? provisioningState = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new GrafanaPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EnterpriseDetails"/>. </summary>
        /// <param name="saasSubscriptionDetails"> SaaS subscription details of a Grafana instance. </param>
        /// <param name="marketplaceTrialQuota"> The allocation details of the per subscription free trial slot of the subscription. </param>
        /// <returns> A new <see cref="Models.EnterpriseDetails"/> instance for mocking. </returns>
        public static EnterpriseDetails EnterpriseDetails(SaasSubscriptionDetails saasSubscriptionDetails = null, MarketplaceTrialQuota marketplaceTrialQuota = null)
        {
            return new EnterpriseDetails(saasSubscriptionDetails, marketplaceTrialQuota, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SaasSubscriptionDetails"/>. </summary>
        /// <param name="planId"> The plan Id of the SaaS subscription. </param>
        /// <param name="offerId"> The offer Id of the SaaS subscription. </param>
        /// <param name="publisherId"> The publisher Id of the SaaS subscription. </param>
        /// <param name="term"> The billing term of the SaaS Subscription. </param>
        /// <returns> A new <see cref="Models.SaasSubscriptionDetails"/> instance for mocking. </returns>
        public static SaasSubscriptionDetails SaasSubscriptionDetails(string planId = null, string offerId = null, string publisherId = null, SubscriptionTerm term = null)
        {
            return new SaasSubscriptionDetails(planId, offerId, publisherId, term, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubscriptionTerm"/>. </summary>
        /// <param name="termUnit"> The unit of the billing term. </param>
        /// <param name="startOn"> The date and time in UTC of when the billing term starts. </param>
        /// <param name="endOn"> The date and time in UTC of when the billing term ends. </param>
        /// <returns> A new <see cref="Models.SubscriptionTerm"/> instance for mocking. </returns>
        public static SubscriptionTerm SubscriptionTerm(string termUnit = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null)
        {
            return new SubscriptionTerm(termUnit, startOn, endOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MarketplaceTrialQuota"/>. </summary>
        /// <param name="availablePromotion"> Available enterprise promotion for the subscription. </param>
        /// <param name="grafanaResourceId"> Resource Id of the Grafana resource which is doing the trial. </param>
        /// <param name="trialStartOn"> The date and time in UTC of when the trial starts. </param>
        /// <param name="trialEndOn"> The date and time in UTC of when the trial ends. </param>
        /// <returns> A new <see cref="Models.MarketplaceTrialQuota"/> instance for mocking. </returns>
        public static MarketplaceTrialQuota MarketplaceTrialQuota(AvailablePromotion? availablePromotion = null, ResourceIdentifier grafanaResourceId = null, DateTimeOffset? trialStartOn = null, DateTimeOffset? trialEndOn = null)
        {
            return new MarketplaceTrialQuota(availablePromotion, grafanaResourceId, trialStartOn, trialEndOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GrafanaAvailablePlugin"/>. </summary>
        /// <param name="pluginId"> Grafana plugin id. </param>
        /// <param name="name"> Grafana plugin display name. </param>
        /// <returns> A new <see cref="Models.GrafanaAvailablePlugin"/> instance for mocking. </returns>
        public static GrafanaAvailablePlugin GrafanaAvailablePlugin(string pluginId = null, string name = null)
        {
            return new GrafanaAvailablePlugin(pluginId, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Grafana.ManagedPrivateEndpointModelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource for which the managed private endpoint is pointing to. </param>
        /// <param name="privateLinkResourceRegion"> The region of the resource to which the managed private endpoint is pointing to. </param>
        /// <param name="groupIds"> The group Ids of the managed private endpoint. </param>
        /// <param name="requestMessage"> User input request message of the managed private endpoint. </param>
        /// <param name="connectionState"> The state of managed private endpoint connection. </param>
        /// <param name="privateLinkServiceUri"> The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port. </param>
        /// <param name="privateLinkServicePrivateIP"> The private IP of private endpoint after approval. This property is empty before connection is approved. </param>
        /// <returns> A new <see cref="Grafana.ManagedPrivateEndpointModelData"/> instance for mocking. </returns>
        public static ManagedPrivateEndpointModelData ManagedPrivateEndpointModelData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, GrafanaProvisioningState? provisioningState = null, ResourceIdentifier privateLinkResourceId = null, string privateLinkResourceRegion = null, IEnumerable<string> groupIds = null, string requestMessage = null, ManagedPrivateEndpointConnectionState connectionState = null, Uri privateLinkServiceUri = null, string privateLinkServicePrivateIP = null)
        {
            tags ??= new Dictionary<string, string>();
            groupIds ??= new List<string>();

            return new ManagedPrivateEndpointModelData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                privateLinkResourceId,
                privateLinkResourceRegion,
                groupIds?.ToList(),
                requestMessage,
                connectionState,
                privateLinkServiceUri,
                privateLinkServicePrivateIP,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedPrivateEndpointConnectionState"/>. </summary>
        /// <param name="status"> The approval/rejection status of managed private endpoint connection. </param>
        /// <param name="description"> Gets or sets the reason for approval/rejection of the connection. </param>
        /// <returns> A new <see cref="Models.ManagedPrivateEndpointConnectionState"/> instance for mocking. </returns>
        public static ManagedPrivateEndpointConnectionState ManagedPrivateEndpointConnectionState(ManagedPrivateEndpointConnectionStatus? status = null, string description = null)
        {
            return new ManagedPrivateEndpointConnectionState(status, description, serializedAdditionalRawData: null);
        }
    }
}
