// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Grafana.Models;

namespace Azure.ResourceManager.Grafana.Samples
{
    public partial class Sample_ManagedPrivateEndpointModelResource
    {
        // ManagedPrivateEndpoint_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ManagedPrivateEndpointGet()
        {
            // Generated from example definition: specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/ManagedPrivateEndpoints_Get.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedPrivateEndpointModelResource created on azure
            // for more information of creating ManagedPrivateEndpointModelResource, please refer to the document of ManagedPrivateEndpointModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string workspaceName = "myWorkspace";
            string managedPrivateEndpointName = "myMPEName";
            ResourceIdentifier managedPrivateEndpointModelResourceId = ManagedPrivateEndpointModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, managedPrivateEndpointName);
            ManagedPrivateEndpointModelResource managedPrivateEndpointModel = client.GetManagedPrivateEndpointModelResource(managedPrivateEndpointModelResourceId);

            // invoke the operation
            ManagedPrivateEndpointModelResource result = await managedPrivateEndpointModel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedPrivateEndpointModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ManagedPrivateEndpoints_Patch
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ManagedPrivateEndpointsPatch()
        {
            // Generated from example definition: specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/ManagedPrivateEndpoints_Patch.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedPrivateEndpointModelResource created on azure
            // for more information of creating ManagedPrivateEndpointModelResource, please refer to the document of ManagedPrivateEndpointModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string workspaceName = "myWorkspace";
            string managedPrivateEndpointName = "myMPEName";
            ResourceIdentifier managedPrivateEndpointModelResourceId = ManagedPrivateEndpointModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, managedPrivateEndpointName);
            ManagedPrivateEndpointModelResource managedPrivateEndpointModel = client.GetManagedPrivateEndpointModelResource(managedPrivateEndpointModelResourceId);

            // invoke the operation
            ManagedPrivateEndpointModelPatch patch = new ManagedPrivateEndpointModelPatch()
            {
                Tags =
{
["Environment"] = "Dev 2",
},
            };
            ArmOperation<ManagedPrivateEndpointModelResource> lro = await managedPrivateEndpointModel.UpdateAsync(WaitUntil.Completed, patch);
            ManagedPrivateEndpointModelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ManagedPrivateEndpointModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ManagedPrivateEndpoint_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ManagedPrivateEndpointDelete()
        {
            // Generated from example definition: specification/dashboard/resource-manager/Microsoft.Dashboard/stable/2023-09-01/examples/ManagedPrivateEndpoints_Delete.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ManagedPrivateEndpointModelResource created on azure
            // for more information of creating ManagedPrivateEndpointModelResource, please refer to the document of ManagedPrivateEndpointModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string workspaceName = "myWorkspace";
            string managedPrivateEndpointName = "myMPEName";
            ResourceIdentifier managedPrivateEndpointModelResourceId = ManagedPrivateEndpointModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workspaceName, managedPrivateEndpointName);
            ManagedPrivateEndpointModelResource managedPrivateEndpointModel = client.GetManagedPrivateEndpointModelResource(managedPrivateEndpointModelResourceId);

            // invoke the operation
            await managedPrivateEndpointModel.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
