// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Describes type of rule. </summary>
    public readonly partial struct WebApplicationRuleType : IEquatable<WebApplicationRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MatchRuleValue = "MatchRule";
        private const string RateLimitRuleValue = "RateLimitRule";

        /// <summary> MatchRule. </summary>
        public static WebApplicationRuleType MatchRule { get; } = new WebApplicationRuleType(MatchRuleValue);
        /// <summary> RateLimitRule. </summary>
        public static WebApplicationRuleType RateLimitRule { get; } = new WebApplicationRuleType(RateLimitRuleValue);
        /// <summary> Determines if two <see cref="WebApplicationRuleType"/> values are the same. </summary>
        public static bool operator ==(WebApplicationRuleType left, WebApplicationRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationRuleType"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationRuleType left, WebApplicationRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationRuleType"/>. </summary>
        public static implicit operator WebApplicationRuleType(string value) => new WebApplicationRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
