// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Describes what transforms applied before matching. </summary>
    public readonly partial struct WebApplicationRuleMatchTransformType : IEquatable<WebApplicationRuleMatchTransformType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationRuleMatchTransformType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationRuleMatchTransformType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowercaseValue = "Lowercase";
        private const string UppercaseValue = "Uppercase";
        private const string TrimValue = "Trim";
        private const string UriDecodeValue = "UrlDecode";
        private const string UriEncodeValue = "UrlEncode";
        private const string RemoveNullsValue = "RemoveNulls";

        /// <summary> Lowercase. </summary>
        public static WebApplicationRuleMatchTransformType Lowercase { get; } = new WebApplicationRuleMatchTransformType(LowercaseValue);
        /// <summary> Uppercase. </summary>
        public static WebApplicationRuleMatchTransformType Uppercase { get; } = new WebApplicationRuleMatchTransformType(UppercaseValue);
        /// <summary> Trim. </summary>
        public static WebApplicationRuleMatchTransformType Trim { get; } = new WebApplicationRuleMatchTransformType(TrimValue);
        /// <summary> UrlDecode. </summary>
        public static WebApplicationRuleMatchTransformType UriDecode { get; } = new WebApplicationRuleMatchTransformType(UriDecodeValue);
        /// <summary> UrlEncode. </summary>
        public static WebApplicationRuleMatchTransformType UriEncode { get; } = new WebApplicationRuleMatchTransformType(UriEncodeValue);
        /// <summary> RemoveNulls. </summary>
        public static WebApplicationRuleMatchTransformType RemoveNulls { get; } = new WebApplicationRuleMatchTransformType(RemoveNullsValue);
        /// <summary> Determines if two <see cref="WebApplicationRuleMatchTransformType"/> values are the same. </summary>
        public static bool operator ==(WebApplicationRuleMatchTransformType left, WebApplicationRuleMatchTransformType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationRuleMatchTransformType"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationRuleMatchTransformType left, WebApplicationRuleMatchTransformType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationRuleMatchTransformType"/>. </summary>
        public static implicit operator WebApplicationRuleMatchTransformType(string value) => new WebApplicationRuleMatchTransformType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationRuleMatchTransformType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationRuleMatchTransformType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
