// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Comparison type to use for matching with the variable value. </summary>
    public readonly partial struct WebApplicationRuleMatchOperator : IEquatable<WebApplicationRuleMatchOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationRuleMatchOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationRuleMatchOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string IPMatchValue = "IPMatch";
        private const string GeoMatchValue = "GeoMatch";
        private const string EqualValue = "Equal";
        private const string ContainsValue = "Contains";
        private const string LessThanValue = "LessThan";
        private const string GreaterThanValue = "GreaterThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string BeginsWithValue = "BeginsWith";
        private const string EndsWithValue = "EndsWith";
        private const string RegEXValue = "RegEx";

        /// <summary> Any. </summary>
        public static WebApplicationRuleMatchOperator Any { get; } = new WebApplicationRuleMatchOperator(AnyValue);
        /// <summary> IPMatch. </summary>
        public static WebApplicationRuleMatchOperator IPMatch { get; } = new WebApplicationRuleMatchOperator(IPMatchValue);
        /// <summary> GeoMatch. </summary>
        public static WebApplicationRuleMatchOperator GeoMatch { get; } = new WebApplicationRuleMatchOperator(GeoMatchValue);
        /// <summary> Equal. </summary>
        public static WebApplicationRuleMatchOperator Equal { get; } = new WebApplicationRuleMatchOperator(EqualValue);
        /// <summary> Contains. </summary>
        public static WebApplicationRuleMatchOperator Contains { get; } = new WebApplicationRuleMatchOperator(ContainsValue);
        /// <summary> LessThan. </summary>
        public static WebApplicationRuleMatchOperator LessThan { get; } = new WebApplicationRuleMatchOperator(LessThanValue);
        /// <summary> GreaterThan. </summary>
        public static WebApplicationRuleMatchOperator GreaterThan { get; } = new WebApplicationRuleMatchOperator(GreaterThanValue);
        /// <summary> LessThanOrEqual. </summary>
        public static WebApplicationRuleMatchOperator LessThanOrEqual { get; } = new WebApplicationRuleMatchOperator(LessThanOrEqualValue);
        /// <summary> GreaterThanOrEqual. </summary>
        public static WebApplicationRuleMatchOperator GreaterThanOrEqual { get; } = new WebApplicationRuleMatchOperator(GreaterThanOrEqualValue);
        /// <summary> BeginsWith. </summary>
        public static WebApplicationRuleMatchOperator BeginsWith { get; } = new WebApplicationRuleMatchOperator(BeginsWithValue);
        /// <summary> EndsWith. </summary>
        public static WebApplicationRuleMatchOperator EndsWith { get; } = new WebApplicationRuleMatchOperator(EndsWithValue);
        /// <summary> RegEx. </summary>
        public static WebApplicationRuleMatchOperator RegEX { get; } = new WebApplicationRuleMatchOperator(RegEXValue);
        /// <summary> Determines if two <see cref="WebApplicationRuleMatchOperator"/> values are the same. </summary>
        public static bool operator ==(WebApplicationRuleMatchOperator left, WebApplicationRuleMatchOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationRuleMatchOperator"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationRuleMatchOperator left, WebApplicationRuleMatchOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationRuleMatchOperator"/>. </summary>
        public static implicit operator WebApplicationRuleMatchOperator(string value) => new WebApplicationRuleMatchOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationRuleMatchOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationRuleMatchOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
