// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. </summary>
    public readonly partial struct SessionAffinityEnabledState : IEquatable<SessionAffinityEnabledState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SessionAffinityEnabledState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SessionAffinityEnabledState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static SessionAffinityEnabledState Enabled { get; } = new SessionAffinityEnabledState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static SessionAffinityEnabledState Disabled { get; } = new SessionAffinityEnabledState(DisabledValue);
        /// <summary> Determines if two <see cref="SessionAffinityEnabledState"/> values are the same. </summary>
        public static bool operator ==(SessionAffinityEnabledState left, SessionAffinityEnabledState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SessionAffinityEnabledState"/> values are not the same. </summary>
        public static bool operator !=(SessionAffinityEnabledState left, SessionAffinityEnabledState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SessionAffinityEnabledState"/>. </summary>
        public static implicit operator SessionAffinityEnabledState(string value) => new SessionAffinityEnabledState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SessionAffinityEnabledState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SessionAffinityEnabledState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
