// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> When matchVariable is a collection, operate on the selector to specify which elements in the collection this rule applies to. </summary>
    public readonly partial struct ScrubbingRuleEntryMatchOperator : IEquatable<ScrubbingRuleEntryMatchOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScrubbingRuleEntryMatchOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScrubbingRuleEntryMatchOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsAnyValue = "EqualsAny";
        private const string EqualsValueValue = "Equals";

        /// <summary> EqualsAny. </summary>
        public static ScrubbingRuleEntryMatchOperator EqualsAny { get; } = new ScrubbingRuleEntryMatchOperator(EqualsAnyValue);
        /// <summary> Equals. </summary>
        public static ScrubbingRuleEntryMatchOperator EqualsValue { get; } = new ScrubbingRuleEntryMatchOperator(EqualsValueValue);
        /// <summary> Determines if two <see cref="ScrubbingRuleEntryMatchOperator"/> values are the same. </summary>
        public static bool operator ==(ScrubbingRuleEntryMatchOperator left, ScrubbingRuleEntryMatchOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScrubbingRuleEntryMatchOperator"/> values are not the same. </summary>
        public static bool operator !=(ScrubbingRuleEntryMatchOperator left, ScrubbingRuleEntryMatchOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScrubbingRuleEntryMatchOperator"/>. </summary>
        public static implicit operator ScrubbingRuleEntryMatchOperator(string value) => new ScrubbingRuleEntryMatchOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScrubbingRuleEntryMatchOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScrubbingRuleEntryMatchOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
