// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Which type of manipulation to apply to the header. </summary>
    public readonly partial struct RulesEngineHeaderActionType : IEquatable<RulesEngineHeaderActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RulesEngineHeaderActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RulesEngineHeaderActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AppendValue = "Append";
        private const string DeleteValue = "Delete";
        private const string OverwriteValue = "Overwrite";

        /// <summary> Append. </summary>
        public static RulesEngineHeaderActionType Append { get; } = new RulesEngineHeaderActionType(AppendValue);
        /// <summary> Delete. </summary>
        public static RulesEngineHeaderActionType Delete { get; } = new RulesEngineHeaderActionType(DeleteValue);
        /// <summary> Overwrite. </summary>
        public static RulesEngineHeaderActionType Overwrite { get; } = new RulesEngineHeaderActionType(OverwriteValue);
        /// <summary> Determines if two <see cref="RulesEngineHeaderActionType"/> values are the same. </summary>
        public static bool operator ==(RulesEngineHeaderActionType left, RulesEngineHeaderActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RulesEngineHeaderActionType"/> values are not the same. </summary>
        public static bool operator !=(RulesEngineHeaderActionType left, RulesEngineHeaderActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RulesEngineHeaderActionType"/>. </summary>
        public static implicit operator RulesEngineHeaderActionType(string value) => new RulesEngineHeaderActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RulesEngineHeaderActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RulesEngineHeaderActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
