// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Defines the action to take on rule match. </summary>
    public readonly partial struct RuleMatchActionType : IEquatable<RuleMatchActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RuleMatchActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RuleMatchActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string BlockValue = "Block";
        private const string LogValue = "Log";
        private const string RedirectValue = "Redirect";
        private const string AnomalyScoringValue = "AnomalyScoring";
        private const string JSChallengeValue = "JSChallenge";

        /// <summary> Allow. </summary>
        public static RuleMatchActionType Allow { get; } = new RuleMatchActionType(AllowValue);
        /// <summary> Block. </summary>
        public static RuleMatchActionType Block { get; } = new RuleMatchActionType(BlockValue);
        /// <summary> Log. </summary>
        public static RuleMatchActionType Log { get; } = new RuleMatchActionType(LogValue);
        /// <summary> Redirect. </summary>
        public static RuleMatchActionType Redirect { get; } = new RuleMatchActionType(RedirectValue);
        /// <summary> AnomalyScoring. </summary>
        public static RuleMatchActionType AnomalyScoring { get; } = new RuleMatchActionType(AnomalyScoringValue);
        /// <summary> JSChallenge. </summary>
        public static RuleMatchActionType JSChallenge { get; } = new RuleMatchActionType(JSChallengeValue);
        /// <summary> Determines if two <see cref="RuleMatchActionType"/> values are the same. </summary>
        public static bool operator ==(RuleMatchActionType left, RuleMatchActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RuleMatchActionType"/> values are not the same. </summary>
        public static bool operator !=(RuleMatchActionType left, RuleMatchActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RuleMatchActionType"/>. </summary>
        public static implicit operator RuleMatchActionType(string value) => new RuleMatchActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RuleMatchActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RuleMatchActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
