// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Defines the properties of a preconfigured endpoint. </summary>
    public partial class PreconfiguredEndpoint : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PreconfiguredEndpoint"/>. </summary>
        /// <param name="location"> The location. </param>
        public PreconfiguredEndpoint(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="PreconfiguredEndpoint"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> The description of the endpoint. </param>
        /// <param name="endpoint"> The endpoint that is preconfigured. </param>
        /// <param name="endpointType"> The type of endpoint. </param>
        /// <param name="backend"> The preconfigured endpoint backend. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PreconfiguredEndpoint(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string description, string endpoint, FrontDoorEndpointType? endpointType, string backend, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Description = description;
            Endpoint = endpoint;
            EndpointType = endpointType;
            Backend = backend;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PreconfiguredEndpoint"/> for deserialization. </summary>
        internal PreconfiguredEndpoint()
        {
        }

        /// <summary> The description of the endpoint. </summary>
        public string Description { get; set; }
        /// <summary> The endpoint that is preconfigured. </summary>
        public string Endpoint { get; set; }
        /// <summary> The type of endpoint. </summary>
        public FrontDoorEndpointType? EndpointType { get; set; }
        /// <summary> The preconfigured endpoint backend. </summary>
        public string Backend { get; set; }
    }
}
