// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Defines the server side resource status. </summary>
    public readonly partial struct NetworkExperimentResourceState : IEquatable<NetworkExperimentResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkExperimentResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkExperimentResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisablingValue = "Disabling";
        private const string DisabledValue = "Disabled";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static NetworkExperimentResourceState Creating { get; } = new NetworkExperimentResourceState(CreatingValue);
        /// <summary> Enabling. </summary>
        public static NetworkExperimentResourceState Enabling { get; } = new NetworkExperimentResourceState(EnablingValue);
        /// <summary> Enabled. </summary>
        public static NetworkExperimentResourceState Enabled { get; } = new NetworkExperimentResourceState(EnabledValue);
        /// <summary> Disabling. </summary>
        public static NetworkExperimentResourceState Disabling { get; } = new NetworkExperimentResourceState(DisablingValue);
        /// <summary> Disabled. </summary>
        public static NetworkExperimentResourceState Disabled { get; } = new NetworkExperimentResourceState(DisabledValue);
        /// <summary> Deleting. </summary>
        public static NetworkExperimentResourceState Deleting { get; } = new NetworkExperimentResourceState(DeletingValue);
        /// <summary> Determines if two <see cref="NetworkExperimentResourceState"/> values are the same. </summary>
        public static bool operator ==(NetworkExperimentResourceState left, NetworkExperimentResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkExperimentResourceState"/> values are not the same. </summary>
        public static bool operator !=(NetworkExperimentResourceState left, NetworkExperimentResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkExperimentResourceState"/>. </summary>
        public static implicit operator NetworkExperimentResourceState(string value) => new NetworkExperimentResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkExperimentResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkExperimentResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
