// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. </summary>
    public readonly partial struct ManagedRuleExclusionSelectorMatchOperator : IEquatable<ManagedRuleExclusionSelectorMatchOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedRuleExclusionSelectorMatchOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedRuleExclusionSelectorMatchOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsValueValue = "Equals";
        private const string ContainsValue = "Contains";
        private const string StartsWithValue = "StartsWith";
        private const string EndsWithValue = "EndsWith";
        private const string EqualsAnyValue = "EqualsAny";

        /// <summary> Equals. </summary>
        public static ManagedRuleExclusionSelectorMatchOperator EqualsValue { get; } = new ManagedRuleExclusionSelectorMatchOperator(EqualsValueValue);
        /// <summary> Contains. </summary>
        public static ManagedRuleExclusionSelectorMatchOperator Contains { get; } = new ManagedRuleExclusionSelectorMatchOperator(ContainsValue);
        /// <summary> StartsWith. </summary>
        public static ManagedRuleExclusionSelectorMatchOperator StartsWith { get; } = new ManagedRuleExclusionSelectorMatchOperator(StartsWithValue);
        /// <summary> EndsWith. </summary>
        public static ManagedRuleExclusionSelectorMatchOperator EndsWith { get; } = new ManagedRuleExclusionSelectorMatchOperator(EndsWithValue);
        /// <summary> EqualsAny. </summary>
        public static ManagedRuleExclusionSelectorMatchOperator EqualsAny { get; } = new ManagedRuleExclusionSelectorMatchOperator(EqualsAnyValue);
        /// <summary> Determines if two <see cref="ManagedRuleExclusionSelectorMatchOperator"/> values are the same. </summary>
        public static bool operator ==(ManagedRuleExclusionSelectorMatchOperator left, ManagedRuleExclusionSelectorMatchOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedRuleExclusionSelectorMatchOperator"/> values are not the same. </summary>
        public static bool operator !=(ManagedRuleExclusionSelectorMatchOperator left, ManagedRuleExclusionSelectorMatchOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedRuleExclusionSelectorMatchOperator"/>. </summary>
        public static implicit operator ManagedRuleExclusionSelectorMatchOperator(string value) => new ManagedRuleExclusionSelectorMatchOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedRuleExclusionSelectorMatchOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedRuleExclusionSelectorMatchOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
