// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Exclude variables from managed rule evaluation. </summary>
    public partial class ManagedRuleExclusion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedRuleExclusion"/>. </summary>
        /// <param name="matchVariable"> The variable type to be excluded. </param>
        /// <param name="selectorMatchOperator"> Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. </param>
        /// <param name="selector"> Selector value for which elements in the collection this exclusion applies to. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="selector"/> is null. </exception>
        public ManagedRuleExclusion(ManagedRuleExclusionMatchVariable matchVariable, ManagedRuleExclusionSelectorMatchOperator selectorMatchOperator, string selector)
        {
            Argument.AssertNotNull(selector, nameof(selector));

            MatchVariable = matchVariable;
            SelectorMatchOperator = selectorMatchOperator;
            Selector = selector;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedRuleExclusion"/>. </summary>
        /// <param name="matchVariable"> The variable type to be excluded. </param>
        /// <param name="selectorMatchOperator"> Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. </param>
        /// <param name="selector"> Selector value for which elements in the collection this exclusion applies to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedRuleExclusion(ManagedRuleExclusionMatchVariable matchVariable, ManagedRuleExclusionSelectorMatchOperator selectorMatchOperator, string selector, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MatchVariable = matchVariable;
            SelectorMatchOperator = selectorMatchOperator;
            Selector = selector;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedRuleExclusion"/> for deserialization. </summary>
        internal ManagedRuleExclusion()
        {
        }

        /// <summary> The variable type to be excluded. </summary>
        public ManagedRuleExclusionMatchVariable MatchVariable { get; set; }
        /// <summary> Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. </summary>
        public ManagedRuleExclusionSelectorMatchOperator SelectorMatchOperator { get; set; }
        /// <summary> Selector value for which elements in the collection this exclusion applies to. </summary>
        public string Selector { get; set; }
    }
}
