// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The LatencyScorecardAggregationInterval. </summary>
    public readonly partial struct LatencyScorecardAggregationInterval : IEquatable<LatencyScorecardAggregationInterval>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LatencyScorecardAggregationInterval"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LatencyScorecardAggregationInterval(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";
        private const string WeeklyValue = "Weekly";
        private const string MonthlyValue = "Monthly";

        /// <summary> Daily. </summary>
        public static LatencyScorecardAggregationInterval Daily { get; } = new LatencyScorecardAggregationInterval(DailyValue);
        /// <summary> Weekly. </summary>
        public static LatencyScorecardAggregationInterval Weekly { get; } = new LatencyScorecardAggregationInterval(WeeklyValue);
        /// <summary> Monthly. </summary>
        public static LatencyScorecardAggregationInterval Monthly { get; } = new LatencyScorecardAggregationInterval(MonthlyValue);
        /// <summary> Determines if two <see cref="LatencyScorecardAggregationInterval"/> values are the same. </summary>
        public static bool operator ==(LatencyScorecardAggregationInterval left, LatencyScorecardAggregationInterval right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LatencyScorecardAggregationInterval"/> values are not the same. </summary>
        public static bool operator !=(LatencyScorecardAggregationInterval left, LatencyScorecardAggregationInterval right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LatencyScorecardAggregationInterval"/>. </summary>
        public static implicit operator LatencyScorecardAggregationInterval(string value) => new LatencyScorecardAggregationInterval(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LatencyScorecardAggregationInterval other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LatencyScorecardAggregationInterval other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
