// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Defines the properties of a latency metric used in the latency scorecard. </summary>
    public partial class LatencyMetric
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LatencyMetric"/>. </summary>
        public LatencyMetric()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LatencyMetric"/>. </summary>
        /// <param name="name"> The name of the Latency Metric. </param>
        /// <param name="endOn"> The end time of the Latency Scorecard in UTC. </param>
        /// <param name="aValue"> The metric value of the A endpoint. </param>
        /// <param name="bValue"> The metric value of the B endpoint. </param>
        /// <param name="delta"> The difference in value between endpoint A and B. </param>
        /// <param name="deltaPercent"> The percent difference between endpoint A and B. </param>
        /// <param name="acLower95CI"> The lower end of the 95% confidence interval for endpoint A. </param>
        /// <param name="ahUpper95CI"> The upper end of the 95% confidence interval for endpoint A. </param>
        /// <param name="bcLower95CI"> The lower end of the 95% confidence interval for endpoint B. </param>
        /// <param name="bUpper95CI"> The upper end of the 95% confidence interval for endpoint B. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LatencyMetric(string name, DateTimeOffset? endOn, float? aValue, float? bValue, float? delta, float? deltaPercent, float? acLower95CI, float? ahUpper95CI, float? bcLower95CI, float? bUpper95CI, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            EndOn = endOn;
            AValue = aValue;
            BValue = bValue;
            Delta = delta;
            DeltaPercent = deltaPercent;
            ACLower95CI = acLower95CI;
            AHUpper95CI = ahUpper95CI;
            BCLower95CI = bcLower95CI;
            BUpper95CI = bUpper95CI;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the Latency Metric. </summary>
        public string Name { get; }
        /// <summary> The end time of the Latency Scorecard in UTC. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The metric value of the A endpoint. </summary>
        public float? AValue { get; }
        /// <summary> The metric value of the B endpoint. </summary>
        public float? BValue { get; }
        /// <summary> The difference in value between endpoint A and B. </summary>
        public float? Delta { get; }
        /// <summary> The percent difference between endpoint A and B. </summary>
        public float? DeltaPercent { get; }
        /// <summary> The lower end of the 95% confidence interval for endpoint A. </summary>
        public float? ACLower95CI { get; }
        /// <summary> The upper end of the 95% confidence interval for endpoint A. </summary>
        public float? AHUpper95CI { get; }
        /// <summary> The lower end of the 95% confidence interval for endpoint B. </summary>
        public float? BCLower95CI { get; }
        /// <summary> The upper end of the 95% confidence interval for endpoint B. </summary>
        public float? BUpper95CI { get; }
    }
}
