// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </summary>
    public readonly partial struct HealthProbeEnabled : IEquatable<HealthProbeEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthProbeEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthProbeEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static HealthProbeEnabled Enabled { get; } = new HealthProbeEnabled(EnabledValue);
        /// <summary> Disabled. </summary>
        public static HealthProbeEnabled Disabled { get; } = new HealthProbeEnabled(DisabledValue);
        /// <summary> Determines if two <see cref="HealthProbeEnabled"/> values are the same. </summary>
        public static bool operator ==(HealthProbeEnabled left, HealthProbeEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthProbeEnabled"/> values are not the same. </summary>
        public static bool operator !=(HealthProbeEnabled left, HealthProbeEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthProbeEnabled"/>. </summary>
        public static implicit operator HealthProbeEnabled(string value) => new HealthProbeEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthProbeEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthProbeEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
