// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. </summary>
    public readonly partial struct FrontendEndpointCustomHttpsProvisioningSubstate : IEquatable<FrontendEndpointCustomHttpsProvisioningSubstate>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontendEndpointCustomHttpsProvisioningSubstate"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontendEndpointCustomHttpsProvisioningSubstate(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubmittingDomainControlValidationRequestValue = "SubmittingDomainControlValidationRequest";
        private const string PendingDomainControlValidationRequestApprovalValue = "PendingDomainControlValidationREquestApproval";
        private const string DomainControlValidationRequestApprovedValue = "DomainControlValidationRequestApproved";
        private const string DomainControlValidationRequestRejectedValue = "DomainControlValidationRequestRejected";
        private const string DomainControlValidationRequestTimedOutValue = "DomainControlValidationRequestTimedOut";
        private const string IssuingCertificateValue = "IssuingCertificate";
        private const string DeployingCertificateValue = "DeployingCertificate";
        private const string CertificateDeployedValue = "CertificateDeployed";
        private const string DeletingCertificateValue = "DeletingCertificate";
        private const string CertificateDeletedValue = "CertificateDeleted";

        /// <summary> SubmittingDomainControlValidationRequest. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate SubmittingDomainControlValidationRequest { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(SubmittingDomainControlValidationRequestValue);
        /// <summary> PendingDomainControlValidationREquestApproval. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate PendingDomainControlValidationRequestApproval { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(PendingDomainControlValidationRequestApprovalValue);
        /// <summary> DomainControlValidationRequestApproved. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate DomainControlValidationRequestApproved { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(DomainControlValidationRequestApprovedValue);
        /// <summary> DomainControlValidationRequestRejected. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate DomainControlValidationRequestRejected { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(DomainControlValidationRequestRejectedValue);
        /// <summary> DomainControlValidationRequestTimedOut. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate DomainControlValidationRequestTimedOut { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(DomainControlValidationRequestTimedOutValue);
        /// <summary> IssuingCertificate. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate IssuingCertificate { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(IssuingCertificateValue);
        /// <summary> DeployingCertificate. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate DeployingCertificate { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(DeployingCertificateValue);
        /// <summary> CertificateDeployed. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate CertificateDeployed { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(CertificateDeployedValue);
        /// <summary> DeletingCertificate. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate DeletingCertificate { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(DeletingCertificateValue);
        /// <summary> CertificateDeleted. </summary>
        public static FrontendEndpointCustomHttpsProvisioningSubstate CertificateDeleted { get; } = new FrontendEndpointCustomHttpsProvisioningSubstate(CertificateDeletedValue);
        /// <summary> Determines if two <see cref="FrontendEndpointCustomHttpsProvisioningSubstate"/> values are the same. </summary>
        public static bool operator ==(FrontendEndpointCustomHttpsProvisioningSubstate left, FrontendEndpointCustomHttpsProvisioningSubstate right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontendEndpointCustomHttpsProvisioningSubstate"/> values are not the same. </summary>
        public static bool operator !=(FrontendEndpointCustomHttpsProvisioningSubstate left, FrontendEndpointCustomHttpsProvisioningSubstate right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontendEndpointCustomHttpsProvisioningSubstate"/>. </summary>
        public static implicit operator FrontendEndpointCustomHttpsProvisioningSubstate(string value) => new FrontendEndpointCustomHttpsProvisioningSubstate(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontendEndpointCustomHttpsProvisioningSubstate other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontendEndpointCustomHttpsProvisioningSubstate other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
